<?PHP 
	$this->load->view('api/header'); 
	$this->load->view('api/nav');
	$this->load->helper('form');
?>

				<h1>Events</h1>
				<div class="column">
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/requests">Requests</a></li>
							<li class="reports-tab ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/reports/events">Events</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/logins">Logins</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/mail">Mail</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/tickets">Tickets</a></li>
						</ul>
					<div class="tab-content">
						<p>This table lists the events.</p>
						<?PHP echo form_open('/reports/events',array('id'=>'reports_form','onsubmit'=>"javascript:submitPaginationForm('', this.value, ".$form_data['items_per_page'].", '');")); ?>
							<table class="form">							
								<tr class="form_row">
									<td>Success:</td>
									<td>
										<select class="fill_row" id="successful" name="successful" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<option value="1" <?php if(isset($form_data['successful']) && '1'==$form_data['successful']){echo "selected";}?>>TRUE</option>
											<option value="0" <?php if(isset($form_data['successful']) && '0'==$form_data['successful']){echo "selected";}?>>FALSE</option>
											<option value="2" <?php if(isset($form_data['successful']) && '2'==$form_data['successful']){echo "selected";}?>>UNAUTH</option>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>ID:</td>
									<td>
										<p class="hidden_context">Help Text for ID: Table ID of event</p>
										<input class="ttFocus" title="Table ID of event" id="event_id" name="event_id" type="text" value="<?php if(isset($form_data['event_id'])) { echo $form_data['event_id']; } ?>" onkeydown="if(event.keyCode == 13){$('#event_id').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for ID</label>
										<select id="event_id_type" name="event_id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['event_id_type']) && $key == $form_data['event_id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>Action:</td>
									<td>
										<p class="hidden_context">Help Text for Action: Action executed</p>
										<input class="ttFocus" title="Action executed" id="action" name="action" type="text" value="<?php if(isset($form_data['action'])) { echo $form_data['action']; } ?>" onkeydown="if(event.keyCode == 13){$('#action').onfocus = function(){this.form.submit();return false;}}"></input>								
									</td>
									<td>
										<label class="hidden_context">Compare options for Action</label>
										<select id="action_type" name="action_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['action_type']) && $key == $form_data['action_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>Target:</td>
									<td>
										<p class="hidden_context">Help Text for Target: Target of the action executed</p>
										<input class="ttFocus" title="Target of the action executed" id="target_user" name="target_user" type="text" value="<?php if(isset($form_data['target_user'])) { echo $form_data['target_user']; } ?>" onkeydown="if(event.keyCode == 13){$('#target_user').onfocus = function(){this.form.submit();return false;}}"></input>								
									</td>
									<td>
										<label class="hidden_context">Compare options for Target</label>
										<select id="target_user_type" name="target_user_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['target_user_type']) && $key == $form_data['target_user_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>Target Type:</td>
									<td>
										<select class="fill_row" id="target_type" name="target_type" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<option value="3" <?php if(isset($form_data['target_type']) && 3==$form_data['target_type']){echo "selected";}?>>User</option>
											<option value="2" <?php if(isset($form_data['target_type']) && 2==$form_data['target_type']){echo "selected";}?>>Application</option>
											<option value="1" <?php if(isset($form_data['target_type']) && 1==$form_data['target_type']){echo "selected";}?>>App Request</option>
											<option value="4" <?php if(isset($form_data['target_type']) && 4==$form_data['target_type']){echo "selected";}?>>User Request</option>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>Actor:</td>
									<td>
										<p class="hidden_context">Help Text for Actor: User or Application executing action</p>
										<input class="ttFocus" title="User or Application executing action" id="acting_user" name="acting_user" type="text" value="<?php if(isset($form_data['acting_user'])) { echo $form_data['acting_user']; } ?>" onkeydown="if(event.keyCode == 13){$('#acting_user').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for Acting</label>
										<select id="acting_user_type" name="acting_user_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['acting_user_type']) && $key == $form_data['acting_user_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>Acting Type:</td>
									<td>
										<select class="fill_row" id="acting_type" name="acting_type" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<option value="3" <?php if(isset($form_data['acting_type']) && 3==$form_data['acting_type']){echo "selected";}?>>User</option>
											<option value="2" <?php if(isset($form_data['acting_type']) && 2==$form_data['acting_type']){echo "selected";}?>>Application</option>
											<option value="1" <?php if(isset($form_data['acting_type']) && 1==$form_data['acting_type']){echo "selected";}?>>App Request</option>
											<option value="4" <?php if(isset($form_data['acting_type']) && 4==$form_data['acting_type']){echo "selected";}?>>User Request</option>
										</select>
									</td>									
								</tr>								
								<tr class="form_row">
									<td>Start Date:</td>
									<td><input type="text" id="start_date" name="start_date" class="date" value="<?php if(isset($form_data['start_date'])) { echo $form_data['start_date']; } ?>"onkeydown="if(event.keyCode == 13){$('#start_date').onfocus=function(){this.form.submit();return false;}}"/></td>
									<td>&nbsp;</td>
									<td>End Date:</td>
									<td><input type="text" id="end_date" name="end_date" class="date" value="<?php if(isset($form_data['end_date'])) { echo $form_data['end_date']; } ?>"onkeydown="if(event.keyCode == 13){$('#end_date').onfocus = function(){this.form.submit();return false;}}"/></td>
								</tr>
								<script>$('input.date').datetimepicker({timeFormat: "hh:mm tt"});</script>
							</table>
							<?PHP
								$hidden_inputs = array(
									'order' => isset($form_data['order']) ? $form_data['order'] : '',
									'direction' => isset($form_data['direction']) ? $form_data['direction'] : '',
									'lastorder' => isset($form_data['order']) ? $form_data['order']  : '',
									'change' => 'false',
									'export' => '0',
									'page_on_bar' => '',
									'items_per_page' => ITEMS_PER_PAGE_DEFAULT,
								);
								echo form_hidden($hidden_inputs,TRUE);
							?>
							<div class="center">
								
								<input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter" ></input>
								<!-- <input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter"></input>-->
								<input class="blue-button" id="clear_button" name="clear_button" type="button" value="Clear" onclick="$('#clear_form').submit();"></input>
							</div>
							<?php if(sizeof($event_list) != 0) { ?>
								<div class="pagination">
									<?php echo $form_data['pages']->display_result_num();?>
									<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
									<?php echo $form_data['pages']->display_items_per_page();?>
									<div style="float:right; position:relative">
										<img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" onclick ="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');" />
										<label class="hidden_context">Page Selector</label>
										<select id="page_select" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '');" >
											<?php for($count = 1;$count <= $form_data['num_pages'];$count++){ ?>
											<option value="<?php echo $count;?>" <?php if($count == $form_data['cur_page']){echo "selected";}?>><?php echo $count;?></option>
											<?php  } ?>
										</select>
										<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
									</div>
								</div>
							<?php } ?>
						<?PHP echo form_close(); ?>
						<?PHP echo form_open('/reports/events',array('id'=>'clear_form')); echo form_close(); ?>
						<?php if(sizeof($event_list) == 0) { ?>
							<div class="message">There are currently no events tracked in the system.</div>
						<?php }else{ ?>					
							<table class="display">	
								<tr class="report_row">
									<th width="5%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','id');$('#change').attr('value','true');$('#reports_form').submit();">ID<?php  if(isset($form_data['order'])&&$form_data['order'] == 'id'){echo $image;} ?></a></th>
									<th width="9%"><a href='#' style="color:#FFFFFF;"onclick="$('#order').attr('value','target_type');$('#change').attr('value','true');$('#reports_form').submit();">Target Type<?php  if(isset($form_data['order'])&&$form_data['order'] == 'target_type'){ echo $image; } ?></a></th>
									<th width="13%"><span href='#' style="color:#FFFFFF;">Target</span></th>
									<th width="8%"><a href='#' style="color:#FFFFFF;"onclick="$('#order').attr('value','actor_type');$('#change').attr('value','true');$('#reports_form').submit();">Actor Type<?php  if(isset($form_data['order'])&&$form_data['order'] == 'actor_type'){ echo $image; } ?></a></th>
									<th width="13%"><span href='#' style="color:#FFFFFF;">Actor</span></th>
									<th width="25%"><a href='#' style="color:#FFFFFF;"onclick="$('#order').attr('value','action');$('#change').attr('value','true');$('#reports_form').submit();">Action<?php  if(isset($form_data['order'])&&$form_data['order'] == 'action'){echo $image; } ?></a></th>
									<th width="11%"><a href='#' style="color:#FFFFFF;"onclick="$('#order').attr('value','event_date');$('#change').attr('value','true');$('#reports_form').submit();">Date (<?php echo $timezone_abbr; ?>)<?php  if(isset($form_data['order'])&&$form_data['order'] == 'event_date'){echo $image; } ?></a></th>
									<th width="7%" class="displaylast"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','success');$('#change').attr('value','true');$('#reports_form').submit();">Success<?php  if(isset($form_data['order'])&&$form_data['order'] == 'success'){ echo $image; } ?></a></th>
								</tr>
								<?php foreach($event_list as $event){ ?>
									<tr class="report_row">
										<td class="break-word"><?php echo $event->id; ?></td>
										<td class="break-word"><?php echo $event->target_type; ?></td>
										<td class="break-word"><?php echo $event->target_id; ?></td>
										<td class="break-word"><?php echo $event->actor_type; ?></td>
										<td class="break-word"><?php echo $event->actor_id; ?></td>
										<td class="break-word" ><?php echo $event->action; ?></td>
										<td class="break-word" ><?php echo $event->event_date; ?></td>
										<td class="break-word " ><?php echo $event->success; ?></td>
									</tr>
								<?php  } ?>
							</table>
							
							<div class="pagination">
								<?php echo $form_data['pages']->display_result_num();?>
								<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
								<?php echo $form_data['pages']->display_items_per_page();?>
								<div style="float:right; position:relative">
									<img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" onclick ="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');" />
									<label class="hidden_context">Page Selector</label>
									<select id="page_select" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '');" >
										<?php for($count = 1;$count <= $form_data['num_pages'];$count++){ ?>
										<option value="<?php echo $count;?>" <?php if($count == $form_data['cur_page']){echo "selected";}?>><?php echo $count;?></option>
										<?php  } ?>
									</select>
									<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
								</div>
							</div>
							
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>